<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\Round;

class RevertAccountChangesCommand extends ContainerAwareCommand
{
    private $Container;

    protected function configure()
    {
        $this
            ->setName('game:account-changes:revert')
            ->setDescription('Game revert account changes')
            ->addOption('roundId', null, InputOption::VALUE_REQUIRED, 'Round ID', 0)
            ->addOption('force', null, InputOption::VALUE_OPTIONAL, 'Force save in DB', false)
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $EntityManager = $this->getDoctrine();
        $ApiGetter = $this->getContainer()->get('vm_admin.api.getter');

        $roundId = $input->getOption('roundId');
        $forceSave = ((integer)$input->getOption('force', false) == 1);
        /** @var Round $Round */
        $Round = $EntityManager->getRepository('VMApiBundle:Round')->find($roundId);

        $output->writeln('Runda <info>' . $Round->getSequence() . '</info>');

        $Teacher = $Round->getGroup()->getUser();
        $groups = $Teacher->getAdminGroups();

        foreach($groups as $UserGroup)
        {
            $Company = $ApiGetter->getGroupCompanyOrFalse($UserGroup);
            $output->writeln('Grupa <info>' . $UserGroup->getName() . '</info>, nazwa firmy: <info>' . $Company->getName() . '</info>');

            $cbso = $Company->getBankServiceOptions();
            foreach($cbso as $CompanyBankServiceOption)
            {
                $output->writeln("\t- <info>" . $CompanyBankServiceOption->getOption()->getBankService()->getName() . " (ID: " . $CompanyBankServiceOption->getId() . ") - " . $CompanyBankServiceOption->getOption()->getName() . ", wartość: " . $CompanyBankServiceOption->getValue(). "</info>");

                if($CompanyBankServiceOption->getOption()->getBankService()->getSymbol() !== 'CURRENT_ACCOUNT')
                {
                    $output->writeln("<error>CBSO nie jest rachunkiem bieżącym</error>");

                    if($forceSave)
                    {
                        $output->writeln("<info>Skrypt przerwany bez wprowadzania zmian</info>");
                        die();
                    }

                    continue;
                }

                $firstCosts = $EntityManager->getRepository('VMApiBundle:AccountChange')->findBy(array('companyBankServiceOptionId' => $CompanyBankServiceOption->getId(), 'roundId' => $Round->getId(), 'description' => 'Koszt zakupu materiałów do produkcji'), array('createAt' => 'ASC'));
                $numberOfCosts = count($firstCosts);
                $output->writeln("\t\t - znaleziono kosztów: " . $numberOfCosts);

                if($numberOfCosts > 1)
                {
                    $FirstCost = $firstCosts[0];
                    $NextCost = $firstCosts[1];
                    $output->writeln("\t\t - koszt o starszej dacie to: " . $FirstCost->getCreateAt()->format("Y-m-d H:i:s") . "(ID: " . $FirstCost->getId() . ")");

                    $Date = clone($FirstCost->getCreateAt());
                    $Date->add(new \DateInterval('PT3S'));

                    $accountChanges = $EntityManager->getRepository('VMApiBundle:AccountChange')->createQueryBuilder('a')
                        ->andWhere('a.companyBankServiceOptionId = :cbsoId')
                        ->andWhere('a.roundId = :roundId')
                        ->andWhere('a.createAt <= :date')
                        ->andWhere('a.id >= :id')
                        ->andWhere('a.id < :nextId')
                        ->setParameter('cbsoId', $CompanyBankServiceOption->getId())
                        ->setParameter('roundId', $Round->getId())
                        ->setParameter('id', $FirstCost->getId())
                        ->setParameter('nextId', $NextCost->getId())
                        ->setParameter('date', $Date->format("Y-m-d H:i:s"))
                        ->getQuery()
                        ->getResult()
                    ;

                    $changes = 0;
                    foreach($accountChanges as $AccountChange)
                    {
                        $changes += (-1) * $AccountChange->getValue();
                        $output->writeln("\t\t\t- " . $AccountChange->getDescription() . ' - <info>' . $AccountChange->getValue(). '</info>');
                        $CompanyBankServiceOption->setValue($CompanyBankServiceOption->getValue() + (-1) * $AccountChange->getValue());
                        $EntityManager->remove($AccountChange);
                    }

                    $output->writeln("\t\t- wielkość zmian <info>" . $changes . "</info>");
                    $output->writeln("\t\t- wartość konta po zmianach <info>" . $CompanyBankServiceOption->getValue() . "</info>");
                }
            }
        }


        if($forceSave)
        {
            $EntityManager->flush();
        }

    }


    /**
     * @return EntityManager
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine.orm.default_entity_manager');
    }
}